#!/usr/bin/perl -w

###################################################
### Please install R and install.package("som") !!!
###################################################

#open(RO, "|R --no-save") || die;
open(RO, "|R --save") || die;

print RO <<"PROCESS";

library("beadarray")
library("illuminaHumanv4.db")

#require(affycoretools)
#require(marray)
#require(gplots)
#require(gtools)
#require(gdata)

dataFile = "Sample_probe_profile_14P0100389_390.txt"
qcFile = "Control_probe_profile_14P0100389_390.txt"

BSData = readBeadSummaryData(dataFile=dataFile, qcFile=qcFile, controlID="ProbeID",skip=0,qc.skip=0, qc.columns=list(exprs = "AVG_Signal", Detection = "Detection Pval"))

dim(BSData)

postscript("Raw.plot.ps",horizontal=F)
par(mfrow = c(1, 2))
boxplot(as.data.frame(log2(exprs(BSData))), las = 2, outline = FALSE, ylab = "log2(intensity)")
boxplot(as.data.frame(nObservations(BSData)), las = 2, outline = FALSE, ylab = "number of beads")
plotMAXY(exprs(BSData), arrays = 1:12, pch = 16)
dev.off()

BSData.norm = normaliseIllumina(BSData, method = "quantile", transform = "log2")
#BSData.norm = normaliseIllumina(BSData, method = "rsn", transform = "log2")
#BSData.norm = normaliseIllumina(BSData,method = "neqc")

esetPROCall = cbind(fData(BSData.norm), exprs(BSData.norm))
write.table(esetPROCall, file="esetPROCall.tsv", sep="\t")

postscript("Normalized.plot.ps",horizontal=F)
par(mfrow = c(1, 2))
boxplot(as.data.frame(exprs(BSData.norm)), las = 2, outline = FALSE, ylab = "log2(intensity)")
boxplot(as.data.frame(nObservations(BSData.norm)), las = 2, outline = FALSE, ylab = "number of beads")
plotMAXY(exprs(BSData.norm), arrays = 1:12,log = FALSE, pch = 16)
dev.off()


BSData.genes = BSData.norm[which(fData(BSData)\$Status == "Gene"), ]
expressed = apply(Detection(BSData.genes) < 0.05, 1, any)
BSData.filt = BSData.genes[expressed, ]
dim(BSData.filt)

esetPROC = cbind(fData(BSData.filt), exprs(BSData.filt))
write.table(esetPROC, file="esetPROC.tsv", sep="\t")


PROCESS

close RO;
