args = commandArgs(trailingOnly=TRUE)
Inpdir = args[1]

fl <- list.files(Inpdir,full.names=T)

for( i in 1:length(fl) ) {

  chem <- gsub("^.*/","",fl[[i]])
  chem <- gsub("\\.csv","", chem)

  output <- system(paste("Rscript DRC_plot.R", fl[[i]]), intern=T, ignore.stderr = TRUE)
  if(i == 1) {
    cat(sprintf("Chemical,Estimate,Std.Error,Lower,Upper\n"))
  }
  e <- output[grep("^e:1:50", output)]
  e <- gsub("[ ]+", ",", e)
  e <- gsub("^e:1:50", chem, e)
  cat(paste(e[[1]],"\n",sep=""))
}
