## Please run by: Rscript DRC_plot.R Filename.csv
args = commandArgs(trailingOnly=TRUE)
infile = args[1]

library(drc, quietly=T)

round2 <- function(x, digit = 0) {
  p <- 10 ^ digit
  s <- ifelse(x >= 0, 1, -1)
  trunc(x * p + s * 0.5) / p
}

indata <- read.csv(infile, header=F)
indata <- t(indata)

alldata <- rbind(indata[,1:2],indata[,c(1,3)],indata[,c(1,4)],indata[,c(1,5)])
colnames(alldata) = c("dose", "measure")
alldata <- data.frame(alldata)

model.LL3 <- drm(measure ~ dose, data=data.frame(alldata), fct=LL.3())

c = 0
b <- model.LL3$coefficients[["b:(Intercept)"]]
d <- model.LL3$coefficients[["d:(Intercept)"]]
e <- model.LL3$coefficients[["e:(Intercept)"]]

IC0.1 <- 1 / b * log((d-c)/(d*0.999-c)-1) + log(e)
IC0.1 <- exp(IC0.1)
IC1 <- 1 / b * log((d-c)/(d*0.99-c)-1) + log(e)
IC1 <- exp(IC1)
IC10 <- 1 / b * log((d-c)/(d*0.9-c)-1) + log(e)
IC10 <- exp(IC10)
IC50 <- 1 / b * log((d-c)/(d*0.5-c)-1) + log(e)
IC50 <- exp(IC50)
IC90 <- 1 / b * log((d-c)/(d*0.1-c)-1) + log(e)
IC90 <- exp(IC90)
IC99 <- 1 / b * log((d-c)/(d*0.01-c)-1) + log(e)
IC99 <- exp(IC99)
IC99.9 <- 1 / b * log((d-c)/(d*0.001-c)-1) + log(e)
IC99.9 <- exp(IC99.9)
IC9999999 <- 1 / b * log((d-c)/(d*0.0000001-c)-1) + log(e)
IC9999999 <- exp(IC9999999)

ED0.1 <- ED(model.LL3, 0.1, interval=("delta"), display=F)
ED10 <- ED(model.LL3, 10, interval=("delta"), display=F)
ED50 <- ED(model.LL3, 50, interval=("delta"), display=F)
ED90 <- ED(model.LL3, 90, interval=("delta"), display=F)
ED99.9 <- ED(model.LL3, 99.9, interval=("delta"), display=F)
ED99.99999 <- ED(model.LL3, 99.99999, interval=("delta"), display=F)

ED0.1
ED50
ED99.9

outfile = infile
outfile = gsub("^.*/", "", outfile)
outfile = gsub("\\.csv$", "", outfile)
pdf(paste(outfile, "pdf", sep="."))

par(mar =c(5,6,4,3), mgp=c(4.5,1,0))
plot(model.LL3, conName="Control", broken=T, type="all", ylim=c(0,max(alldata["measure"])), xlim=c(0,ED99.99999[1]), cex.lab=1.5, xlab="", ylab="Adjusted RLU", main=outfile, cex.main=1.2, pch=16)

title(xlab=expression(paste("Dosage (", mu, M, ")")), line = 2.5, cex.lab=1.5)

plot(model.LL3, conName="Control", type="confidence", broken=T, add=T, confidence.level=0.95, ylim=c(0,max(alldata["measure"])), xlim=c(0,ED99.99999[1]), xlab="", ylab="", xaxt='n', yaxt='n', axes=F, bty='n')

abline(h=0, col="gray10", lwd=0.5)
abline(h=d, col="gray10", lwd=0.5)
abline(h=d * 0.999, col="blue1", lwd=0.5)
abline(h=d * 0.5, col="blue1", lwd=0.5)
arrows(ED0.1[1], 0, ED0.1[1], d*0.999, code=0, col="yellow", lwd=2)
arrows(ED50[1], 0, ED50[1], d*0.5, code=0, col="orange", lwd=2)
text(ED99.99999[1] * 0.8, d*0.97, "IC0.1", bg="white")
text(ED99.99999[1] * 0.8, d*0.53, "IC50", bg="white")

dev.off()
