## Please run by: Rscript C50Box_plot.R Filename.csv
args = commandArgs(trailingOnly=TRUE)
infile = args[1]

library(tidyverse)

IC50 <- read.csv(infile, header=T)
IC50 <- data.frame(IC50)
IC50$Chemical = with(IC50, reorder(Chemical, -Estimate))

outfile = gsub(".csv", ".boxplot.pdf", infile)
pdf(outfile)

ggplot(IC50, mapping=aes(x=Chemical, y=Estimate, color=Chemical)) + geom_pointrange(aes(ymin=Lower, ymax=Upper), size=0.8) + scale_y_log10(limits=c(10^-3,10^4)) + labs(y=expression(paste("IC50 dose (", mu, "M)",sep=""))) + theme(axis.title.y=element_text(size=16), axis.text.y=element_text(size=12)) + theme(axis.title.x=element_blank(), axis.text.x=element_blank(), axis.ticks.x=element_blank()) + theme(legend.title=element_text(colour="black", size=12, face="bold")) + guides(color=guide_legend(nrow=24,override.aes=list(size = 0.8)))
dev.off()
