## Please run by: Rscript C50Box_plot.R Filename.csv
args = commandArgs(trailingOnly=TRUE)
infile1 = args[1]
infile2 = args[2]

library(tidyverse)

IC50ref <- read.csv(infile1, header=T)
IC50ref <- data.frame(IC50ref)
IC50ref$Chemical = with(IC50ref, reorder(Chemical, -Estimate))

IC50 <- read.csv(infile2, header=T)
IC50 <- data.frame(IC50)
IC50$Chemical = with(IC50, reorder(Chemical, -IC50ref$Estimate))

outfile = gsub(".csv", ".boxplot.pdf", infile2)
pdf(outfile)

ggplot(IC50, mapping=aes(x=Chemical, y=Estimate, color=Chemical)) + geom_pointrange(aes(ymin=Lower, ymax=Upper), size=0.8) + scale_y_log10(limits=c(10^-3,10^4)) + labs(y=expression(paste("IC50 dose (", mu, "M)",sep=""))) + theme(axis.title.y=element_text(size=16), axis.text.y=element_text(size=12)) + theme(axis.title.x=element_blank(), axis.text.x=element_blank(), axis.ticks.x=element_blank()) + theme(legend.title=element_text(colour="black", size=12, face="bold")) + guides(color=guide_legend(nrow=24,override.aes=list(size = 0.8)))
dev.off()
