### File path ###
#Time = '24h'
Time = '48h'
Inpfile = paste('LFCfiles.all/LFC.all', Time, 'tsv', sep=".")
Labelfile = 'Label.210715.txt'

### Reading normalized TF gene expression
X <- read.delim(Inpfile, fileEncoding="latin1")
colnames(X) <- read.delim(Inpfile, fileEncoding="latin1", header=F, colClasses = "character")[1,1:ncol(X)]
ChemVec <- unique(gsub("_.*", "", colnames(X)))
ChemVec.sort.id <- vector()
for(s in sort(ChemVec)) {
  ChemVec.sort.id <- c(ChemVec.sort.id, grep(s, colnames(X)))
}
X <- X[ChemVec.sort.id]

library(fgsea)
set.seed(1)

pathways.hallmark <- gmtPathways("msigdb_v7.4_files_to_download_locally/msigdb_v7.4_GMTs/h.all.v7.4.symbols.gmt")
names(pathways.hallmark) <- gsub("^HALLMARK_","",names(pathways.hallmark))

library(ggplot2)
library(ggrepel)

M = matrix(nrow=length(pathways.hallmark), ncol = ncol(X))
rownames(M) = names(pathways.hallmark)
colnames(M) = colnames(X)

library(tidyverse)
X$SYMBOL <- substring(rownames(X), 17)
for(c in 1:(ncol(X)-1)) {
  col_name = gsub("-", "_", colnames(X)[c])
  col_name = gsub("/", "|", colnames(X)[c])
  message(col_name)

  res <- X %>%
    dplyr::select(SYMBOL, c) %>% 
    dplyr::rename(stat = 2) %>%
    na.omit() %>% 
    distinct() %>% 
    group_by(SYMBOL) %>% 
    summarize(stat=mean(stat))

  fgseaRes <- fgsea(pathways=pathways.hallmark, stats=deframe(res), nperm=1000)
  M[,c] <- fgseaRes$padj * sign(fgseaRes$NES)

  fname = sprintf("GSEA.%s.tsv", col_name)
  write.table(as.matrix(fgseaRes[order(NES)]), file=fname, sep="\t", quote=F, row.names=F)

  fname = sprintf("GSEA.%s.0.05.tsv", col_name)
  fgseaRes.sig <- fgseaRes[fgseaRes$padj < 0.05]
  write.table(as.matrix(fgseaRes.sig[order(NES)]), file=fname, sep="\t", quote=F, row.names=F)

  fname = sprintf("GSEA.%s.pdf", col_name)
  pdf(fname, paper="a4")
  plot1 <- ggplot(fgseaRes, aes(reorder(pathway, NES), NES)) + geom_col(aes(fill=padj<0.05)) + coord_flip() + labs(x="Pathway", y="Normalized Enrichment Score", title="Hallmark pathways NES from GSEA") + theme_minimal()
  print(plot1)
  dev.off()
}


LOG10Val <- -log10(abs(M)) * sign(M)

annotation_col = data.frame(
     Dose = factor(rep(c("1/1","1/2","1/4","1/8","1/16"), 24), levels=c("1/1","1/2","1/4","1/8","1/16")),
     Chemical = factor(rep(ChemVec, each=5))
)
mycols <- rainbow(24)
library(gplots)
ann_colors = list(
     Dose = colorpanel(5, low="black", high="gray90"),
     Chemical = mycols
)
names(ann_colors$Chemical) = sort(ChemVec)
names(ann_colors$Dose) = c("1/1","1/2","1/4","1/8","1/16")

library(ComplexHeatmap)
fname = sprintf("GSEA.Summary.%s.pdf", Time)
pdf(fname, width=12)

pairs.breaks <- c(seq(-2, 2, length.out=100))

pheatmap(LOG10Val, cluster_cols=F, cluster_rows=T, labels_row=rownames(LOG10Val), labels_col=colnames(LOG10Val), fontsize_row = 7, fontsize_col = 4, angle_col="90", breaks = pairs.breaks, clustering_method = "average", cutree_col=annotation_col$Chemical, annotation_col = annotation_col, annotation_colors = ann_colors, name="-log10(adj. p-val)", legend_labels=c("2 Down", "1", "0", "1", "2 Up"))
dev.off()


Highdose <- c("1/1", "1/2")
Lowdose <- c("1/8", "1/16")
Alldose <- list(Highdose, Lowdose)
names(Alldose) <- c("High", "Low")
Label <- read.delim(Labelfile, row.names=1)
for(d in 1:length(Alldose)) {
  for(L in 1:ncol(Label)) {
    ToxCategory = colnames(Label)[L]
    ChemsP = rownames(Label)[Label[,L] == 1]
    ChemsN = rownames(Label)[Label[,L] == -1]

    eg <- expand.grid(Alldose[[d]], ChemsP)
    Chemset <- paste(eg[,2], Time, paste(eg[,1],"-",sep=""), sep="_")
    Chemset <- paste(Chemset, collapse="|")
    CidP <- grep(Chemset, colnames(M))

    eg <- expand.grid(Alldose[[d]], ChemsN)
    Chemset <- paste(eg[,2], Time, paste(eg[,1],"-",sep=""), sep="_")
    Chemset <- paste(Chemset, collapse="|")
    CidN <- grep(Chemset, colnames(M))

    MM <- cbind(M[,CidP], M[,CidN])
    PosChems <- unique(gsub("_.*", "", colnames(M[,CidP])))
    NegChems <- unique(gsub("_.*", "", colnames(M[,CidN])))

    LOG10Val <- -log10(abs(MM)) * sign(MM)

    fname = sprintf("GSEA.Category.%s.%s.%s.pdf", ToxCategory, names(Alldose)[d], Time)
    pdf(fname, width=12)

    pairs.breaks <- c(seq(-2, 2, length.out=100))

    annotation_col = data.frame(
         Dose = factor(rep(Alldose[[d]], 24), levels=Alldose[[d]]),
         Chemical = factor(rep(c(PosChems,NegChems), each=2)),
         Category = factor(c(rep(ToxCategory, length(PosChems)*2), rep("others", length(NegChems)*2)), levels=c(ToxCategory, "others"))
    )
    mycols <- rainbow(24)
    dosecolor <- colorpanel(5, low="black", high="gray90")
    if(names(Alldose)[d] == "High") {
      dosecolor <- dosecolor[1:2]
    } else {
      dosecolor <- dosecolor[4:5]
    }
    library(RColorBrewer)
    ann_colors = list(
         Dose = dosecolor,
         Chemical = mycols,
         Category = c(brewer.pal(n = 8, name = "Dark2")[L], "azure")
    )
    names(ann_colors$Chemical) = sort(c(PosChems,NegChems))
    names(ann_colors$Dose) = Alldose[[d]]
    names(ann_colors$Category) = c(ToxCategory, "others")

    pout <- pheatmap(LOG10Val, cluster_cols=F, cluster_rows=T, labels_row=rownames(LOG10Val), labels_col=colnames(LOG10Val), fontsize_row = 7, fontsize_col = 4, angle_col="90", breaks = pairs.breaks, clustering_method = "average", cutree_col=annotation_col$Category, annotation_col = annotation_col, annotation_colors = ann_colors, name="-log10(adj. p-val)", legend_labels=c("2 Down", "1", "0", "1", "2 Up"))

    print(pout)
    dev.off()
  }
}

