### File path ###
Inpfile1 = 'LFCfiles.TF/LFC.all.24h.tsv'
Inpfile2 = 'LFCfiles.TF/LFC.all.48h.tsv'

Labelfile = 'Label.210715.txt'

### Reading normalized TF gene expression files
X.24h <- read.delim(Inpfile1, fileEncoding="latin1")
colnames(X.24h) <- read.delim(Inpfile1, fileEncoding="latin1", header=F, colClasses = "character")[1,1:ncol(X.24h)]
X.24h[is.na(X.24h)] <- 0

X.48h <- read.delim(Inpfile2, fileEncoding="latin1")
colnames(X.48h) <- read.delim(Inpfile2, fileEncoding="latin1", header=F, colClasses = "character")[1,1:ncol(X.48h)]
X.48h[is.na(X.48h)] <- 0

X.all <- as.data.frame(merge(X.24h,X.48h,by="row.names",all=T))
rownames(X.all) <- unlist(X.all[,1])
X.all <- X.all[-1]
X.all[is.na(X.all)] <- 0

### Reading category file
C <- read.delim(Labelfile, row.names=1, fileEncoding="latin1")

### Reading PCA weighted gene file
nPCA = 5
nPos = 2
nNeg = 2

### Calculating EBICglasso for optimized Gaussian graphical model

library(qgraph)

for(Time in c("24h", "48h")) {
  Feature_v = vector()
  Weight_v = vector()
  for(d in 1:nPCA) {
    PCAfile = sprintf("PCA_GWs.TF/GeneWeight.nobatch.PC%s.%s.tsv", d, Time)
    g.tmp <- read.delim(file=PCAfile, fileEncoding="latin1", row.names=1)
    Feature_v = c(Feature_v, rownames(g.tmp)[1:nPos], rownames(g.tmp)[(nrow(g.tmp)-nNeg+1):nrow(g.tmp)])
    Weight_v = c(Weight_v, g.tmp[1:nPos,1], g.tmp[(nrow(g.tmp)-nNeg+1):nrow(g.tmp),1])
  }
  Fmatrix = cbind(Feature_v, Weight_v)
  Feature_v = unique(sort(Feature_v))
  fname = sprintf("Feature_list.%s.tsv", Time)
  write.table(Fmatrix, file=fname, sep="\t", row.names=T, col.names=T, quote=F)
  print(Feature_v)
  F_len = length(Feature_v)
  GN_matrix <- matrix(nrow=((F_len^2-F_len)/2), ncol=0)

  Xobj <- paste("X.", Time, sep="")
  com = paste("X <- t(", Xobj, ")")
  eval(parse(text=com))

  pdf(file=sprintf("GGM.%s.pdf", Time))

  for(i in 1:nrow(C)) {

    Cat = C[i,]
    catname = rownames(Cat)

    #g.tmp = rownames(read.delim(file=sprintf("Borutafiles/BorutaRes.%s.%s.tsv", catname, Time)))
    ### To avoid automatic change of '-' to '.' ###
    D <- X[,match(substring(Feature_v,1,15), substring(colnames(X),1,15))]
    colnames(D) <- substring(colnames(D), 17)
    print(dim(D))

    Chemicals = gsub("_.*$", "", rownames(X))

    message(paste("Calculating GGM for ", catname, "...", sep=""))
    Y = D[grep(catname, Chemicals),]
    colnames(Y) = substring(colnames(Y), 1, 15)
    print(rownames(Y))
    print(dim(Y))

    EBICgraph = EBICglasso(cov(Y), nrow(Y), gamma = 0.0, threshold=F, lambda.min.ratio = 0.01, nlambda = 1000, checkPD=F)
    EBICgraph <- qgraph(EBICgraph, layout="spring", title = catname, edge.labels=T, label.cex=1.0)
    print(EBICgraph)

    mtmp = matrix(nrow=length(Feature_v), ncol=length(Feature_v), data=rep(0,length(Feature_v)^2))
    EBICdata <- cbind(EBICgraph$Edgelist$from, EBICgraph$Edgelist$to, EBICgraph$Edgelist$weight)
    for(r in 1:nrow(EBICdata)) {
      mtmp[EBICdata[r,1], EBICdata[r,2]] = EBICdata[r,3]
    }
    res_v = vector()
    res_v_name = vector()
    for(r in 1:(nrow(mtmp)-1)) {
      for(c in (r+1):nrow(mtmp)) {
        res_v = c(res_v, mtmp[r,c])
        #res_v_name = c(res_v_name, sprintf("gn%s_%s", r, c))
        res_v_name = c(res_v_name, sprintf("%s_%s:%s_%s", substring(Feature_v[r], 1, 15), substring(Feature_v[c], 1, 15), substring(Feature_v[r], 17), substring(Feature_v[c], 17)))
      }
    }
    names(res_v) = res_v_name
    res_v = as.matrix(res_v)
    colnames(res_v) = catname
    GN_matrix <- cbind(GN_matrix, res_v)
  }
  dev.off()
  fname = sprintf("EBIC.%s.tsv", Time)
  write.table(GN_matrix, file=fname, sep="\t", row.names=T, col.names=T, quote=F)
}
