### File path ###
#Time = '24h'
Time = '48h'
Inpfile = paste('LFCallFiles/LFC.all', Time, 'tsv', sep=".")

### Reading normalized TF gene expression
X <- read.delim(Inpfile, fileEncoding="latin1")
colnames(X) <- read.delim(Inpfile, fileEncoding="latin1", header=F, colClasses = "character")[1,1:ncol(X)]

ChemVec <- unique(gsub("_.*", "", colnames(X)))
M = matrix(nrow=length(ChemVec), ncol=length(ChemVec))
colnames(M) = ChemVec
rownames(M) = ChemVec
for(c1 in 1:length(ChemVec)) {
  for(c2 in 1:length(ChemVec)) {
    M[c1,c2] <- cor(unlist(X[grep(ChemVec[c1], colnames(X))]), unlist(X[grep(ChemVec[c2], colnames(X))]))
  }
}

library(gplots)
fname = sprintf("Corr.LFC.%s.pdf", Time)
pdf(fname, paper="a4")

ccfull = M
hM <- format(round(ccfull, 2))
pairs.breaks <- c(seq(-1.0, 1.0, length.out=33))

heatmap.2(ccfull, key.par=list(cex.axis=0.8, mar=c(3, 1.5, 5, 1.5)), keysize=1.0, key.title="", key.xlab=expression(paste("Pearson ", r^2)), density.info="none", Rowv=F, Colv=F, symm=T, col="bluered", key = T, margins = c(10,10), trace="none", cellnote=hM, dendrogram="none", notecol="black", notecex=.3, breaks=pairs.breaks, cexRow=0.9, cexCol=0.9)
heatmap.2(ccfull, key.par=list(cex.axis=0.8, mar=c(3, 1.5, 5, 1.5)), keysize=1.0, key.title="", key.xlab=expression(paste("Pearson ", r^2)), density.info="none", Rowv=T, Colv=T, hclustfun = function(x) hclust(x, method="average"), symm=T, col="bluered", key = T, margins = c(10,10), trace="none", cellnote=hM, dendrogram="none", notecol="black", notecex=.3, breaks=pairs.breaks, cexRow=0.9, cexCol=0.9, revC=T)

heatmap.2(ccfull, key.par=list(cex.axis=0.8, mar=c(3, 1.5, 5, 1.5)), keysize=1.0, key.title="", key.xlab=expression(paste("Pearson ", r^2)), density.info="none", Rowv=F, Colv=F, symm=T, col="bluered", key = T, margins = c(10,10), trace="none", dendrogram="none", notecol="black", notecex=.3, breaks=pairs.breaks, cexRow=0.9, cexCol=0.9)
heatmap.2(ccfull, key.par=list(cex.axis=0.8, mar=c(3, 1.5, 5, 1.5)), keysize=1.0, key.title="", key.xlab=expression(paste("Pearson ", r^2)), density.info="none", Rowv=T, Colv=T, hclustfun = function(x) hclust(x, method="average"), symm=T, col="bluered", key = T, margins = c(10,10), trace="none", dendrogram="none", notecol="black", notecex=.3, breaks=pairs.breaks, cexRow=0.9, cexCol=0.9, revC=T)

dev.off()

