### File path ###
#Time = '24h'
Time = '48h'
Inpfile = paste('LFCallFiles/LFC.all', Time, 'tsv', sep=".")

### Reading normalized TF gene expression
X <- read.delim(Inpfile, fileEncoding="latin1")
colnames(X) <- read.delim(Inpfile, fileEncoding="latin1", header=F, colClasses = "character")[1,1:ncol(X)]

ChemVec <- unique(gsub("_.*", "", colnames(X)))
M = matrix(nrow=length(ChemVec), ncol=nrow(X)*5)
rownames(M) = ChemVec
for(c in 1:length(ChemVec)) {
  M[c,] <- unlist(X[grep(ChemVec[c], colnames(X))])
}

library(uwot)
set.seed(1)
Umap <- as.data.frame(umap(M, n_neighbors=5, metric="correlation", n_epochs = 200, init="spectral"))
rownames(Umap) <- ChemVec
colnames(Umap) <- c("Umap1", "Umap2")
Umap$Chemical <- ChemVec

fname = sprintf("Umap.LFC.%s.pdf", Time)
pdf(fname, paper="a4")
#par(mar=c(5,5,5,8)+0.5, xpd=T)

library(ggplot2)
library(ggrepel)

theme<-theme(panel.background = element_blank(),panel.border=element_rect(fill=NA),panel.grid.major = element_blank(),panel.grid.minor = element_blank(),strip.background=element_blank(),axis.text.x=element_text(colour="black"),axis.text.y=element_text(colour="black"),axis.ticks=element_line(colour="black"),plot.margin=unit(c(1,1,1,1),"line")) + theme(axis.title=element_text(size=16, face="bold"), axis.text=element_text(size=12))

ggplot(Umap, mapping=aes(x=Umap1, y=Umap2, color=Chemical, label=Chemical)) + geom_point(size=3, show.legend=F) + geom_text_repel(col="black",size=4) + theme

dev.off()
