### File path ###
#Time = '24h'
Time = '48h'
Inpfile = paste('LFCfiles.TF/LFC.all', Time, 'tsv', sep=".")

### Reading normalized TF gene expression
X <- read.delim(Inpfile, fileEncoding="latin1")
colnames(X) <- read.delim(Inpfile, fileEncoding="latin1", header=F, colClasses = "character")[1,1:ncol(X)]

ChemVec <- unique(gsub("_.*", "", colnames(X)))
M = matrix(nrow=nrow(X) * 5, ncol=length(ChemVec))
colnames(M) = ChemVec
for(c in 1:length(ChemVec)) {
  M[,c] <- unlist(X[grep(ChemVec[c], colnames(X))])
}

rn <- expand.grid(rownames(X), c('1/1', '1/2', '1/4', '1/8', '1/16'))
R = matrix(nrow=nrow(M), ncol=2)
colnames(R) = c("Gene", "NAME")
R[,1] = paste(substring(rn[[1]], 1, 15), rn[[2]], sep="_")
R[,2] = substring(rn[[1]], 17)
M = cbind(R, M)

fname = sprintf("LFC.%s.gene", Time)
write.table(M, file=fname, sep="\t", quote=F, row.names=F)
