GNfile = 'Pred.KhES3.tsv'
MDfile = 'Pred.MD.tsv'
Rawfile = 'Pred.Raw.KhES3.tsv'

GN <- read.table(GNfile, sep=" ", header=F)
MDtmp <- read.table(MDfile, sep=" ", header=F)
Raw <- read.table(Rawfile, sep=" ", header=F)

MD <- MDtmp[c(1,1,2,2,3,3,4,4,5,6,5,6,7,7),]

library(pROC)

round45 <- function (x, digits) 
{
    return(floor(x * 10^digits + 0.5)/10^digits)
}

for(r in 1:nrow(GN)) {

  fname = sprintf("%s.ROC.pdf", GN[r,1])

  pdf(file=fname)
  md <- roc(predictor=as.numeric(unlist(strsplit(MD[r,11], ","))), response=unlist(strsplit(MD[r,13], ",")))
  raw <- roc(predictor=as.numeric(unlist(strsplit(Raw[r,11], ","))), response=unlist(strsplit(Raw[r,13], ",")))
  gn <- roc(predictor=as.numeric(unlist(strsplit(GN[r,11], ","))), response=unlist(strsplit(GN[r,13], ",")))

  plot(md, legacy.axes=T, new=T, lty=4, col="blue", lwd=3, cex.main=1.7, cex.axis=1.3, cex.lab=1.5, font.main=1, font.lab=1, main=gsub("^K-entropy.", "", GN[r,1]))
  plot(raw, legacy.axes=T, add=T, lty=3, col="orange", lwd=3)
  plot(gn, legacy.axes=T, add=T, lty=1, col="red", lwd=5)

  op <- par(cex = 1.3)
  legend(x = 0.5, y = 0.3, bty = "n", lwd = 2, lty = c(1,3,4), legend = c("GGM","RNAseq","MD"), col=c("red", "orange", "blue"))
  legend(x = 0.3, y = 0.3, bty = "n", lwd = 0, lty = 0,
       legend =
       c(
         sprintf("%.3f", round45(gn$auc, 3)),
         sprintf("%.3f", round45(raw$auc, 3)),
         sprintf("%.3f", round45(md$auc, 3))
         )
       )
  dev.off()

}
