#!/usr/bin/perl -w

my $dir0 = $ARGV[0] || die "## Usage: $0 data_dir name_dir ##\n";
my $dir1 = $ARGV[1] || die "## Usage: $0 data_dir name_dir ##\n";

@name_files = <$dir1/*>;

for(my $n = 0; $n <= $#name_files; $n++) {
  my $fname = $name_files[$n];
  my (@dirnames) = split(/\//, $fname);
  my $sname = $dirnames[$#dirnames];
  $sname =~ s/_sample_name//;
  $sname =~ s/_/-/g;
  $sname =~ s/-data/_data/;
  $sname =~ s/^(\d+)//;
  my ($ssname, @dmy) = <$dir0/*$sname>;
  print STDERR "Opening $fname ...\n";
  open(FI, $fname) || die "## FI cannot open $fname ##\n";
  print STDERR "Opening $ssname ...\n";
  open(SI, $ssname) || die "## SI cannot open $dir0/$sname by $ssname ##\n";
  my @sample_idx = ();
  while(<FI>) {
    $_ =~ s/[\n\r]+//g;
    my(@cols) = split(/\t/, $_, -1);
    if($cols[1] =~ /Sample (\d+)$/ && $cols[2] ne '') {
      $sample_idx[$1] = $cols[2];
    }
  }
  close FI;
  my $soname = $dirnames[$#dirnames];
  $soname =~ s/_sample_name.txt/_final.tsv/;
  open(SO, ">$soname") || die "## cannot open $soname ##\n";
  while(<SI>) {
    $_ =~ s/[\n\r]+//g;
    my(@cols) = split(/\t/, $_, -1);
    if(defined($cols[1]) && $cols[1] =~ /Sample (\d+)$/ && $cols[2] ne '') {
      $cols[1] = $sample_idx[$1];
      print SO join("\t", @cols), "\n";
    } else {
      print SO $_, "\n";
    }
  }
  close SI;
  close SO;
}
