#!/usr/bin/perl

my $Time = $ARGV[0];

my $orig_dir = "4.Final_data/${Time}hrs";
my $redo_dir = "4.Final_data/${Time}hrs_redo";

my @orig_files = <$orig_dir/*>;
my @redo_files = <$redo_dir/*>;
my @all_files = @orig_files;
push(@all_files, @redo_files);

my %data = ();
my %chemhash = ();
my %timehash = ();
my %dosehash = ();
my %genehash = ();

foreach my $f(<@all_files>) {
  print STDERR "Opening $f ...\n";
  open(FI, $f) || die "$f cannot open.\n";
  my $flag = 0;
  while(<FI>) {
    $_ =~ s/[\n\r]+//g;
    next if(/^$/);
    if(/^Well/) {
      $flag = 1;
      next;
    } elsif(! $flag) {
      next;
    } elsif(/^Analysis/) {
      $flag = 0;
      next;
    }
    my(@cols) = split(/\t/, $_, -1);
    my $sample_name = $cols[1];

    my($chem, $time, $dose) = split('_', $sample_name, -1);
    next if($sample_name eq '');
    die "## $sample_name ##\n" if($chem eq '' || $time eq '' || $dose eq '');

    my $Ct = $cols[9];
    if($Ct eq 'Undetermined') {
      print STDERR "## Undetermined: $sample_name ##\n";
      next;
    }

    $chemhash{$chem} = 1;
    $timehash{$time} = 1;
    $dosehash{$dose} = 1;

    my $gene = $cols[2]; #Target Name
    $genehash{$gene} = 1;
    #print STDERR join("\t", $chem, $time, $dose, $gene, $Ct), "\n";
    push(@{$data{$chem}->{$gene}->{$dose}->{$time}}, $Ct);
  }
  close FI;
}

my @chemlist = sort keys %chemhash;
my @doselist = sort keys %dosehash;
my @timelist = sort keys %timehash;
my @genelist = sort keys %genehash;

print "#Chemname\tGenename";
for(my $dose = 0; $dose <= $#doselist; $dose++) {
  for(my $time = 0; $time <= $#timelist; $time++) {
     print "\t", $doselist[$dose], ":", $timelist[$time];
  }
}
print "\n";

for(my $chem = 0; $chem <= $#chemlist; $chem++) {
  next if(! $chemlist[$chem]);
  for(my $gene = 0; $gene <= $#genelist; $gene++) {
    for(my $val = 0; $val <= 1; $val++) {
      print $chemlist[$chem], "\t", $genelist[$gene];
      for(my $dose = 0; $dose <= $#doselist; $dose++) {
        for(my $time = 0; $time <= $#timelist; $time++) {
          my @vallist = @{$data{$chemlist[$chem]}->{$genelist[$gene]}->{$doselist[$dose]}->{$timelist[$time]}};
          print "\t", $vallist[$val];
        }
      }
      print "\n";
    }
  }
}
