GNfile = 'Pred.iPS.tsv'

GN <- read.table(GNfile, sep=" ", header=F)

library(pROC)

round45 <- function (x, digits) 
{
    return(floor(x * 10^digits + 0.5)/10^digits)
}

for(r in 1:nrow(GN)) {

  fname = sprintf("%s.ROC.pdf", gsub("K-entropy.iPS.","", GN[r,1]))

  pdf(file=fname)
  gn <- roc(predictor=as.numeric(unlist(strsplit(GN[r,11], ","))), response=unlist(strsplit(GN[r,13], ",")))

  plot(gn, legacy.axes=T, new=T, lty=1, col="blue", lwd=5, cex.main=1.7, cex.axis=1.3, cex.lab=1.5, font.main=1, font.lab=1, main=gsub("^K-entropy.", "", GN[r,1]))
  op <- par(cex = 1.3)
  legend(x = 0.5, y = 0.3, bty = "n", lwd = 2, lty = c(1,3,4), legend = c("GGM"), col=c("blue"))
  legend(x = 0.3, y = 0.3, bty = "n", lwd = 0, lty = 0,
       legend =
       c(
         sprintf("%.3f", round45(gn$auc, 3))
         )
       )
  dev.off()

}
