### File path ###
Inpfile1 = 'GGMfiles/EBIC.24h.tsv'
Inpfile2 = 'GGMfiles/EBIC.48h.tsv'

### Reading normalized TF gene expression files
X.24h <- read.delim(Inpfile1, fileEncoding="latin1")
colnames(X.24h) <- read.delim(Inpfile1, fileEncoding="latin1", header=F, colClasses = "character")[1,1:ncol(X.24h)]
X.24h[is.na(X.24h)] <- 0

D24h <- cbind(as.matrix(substring(rownames(X.24h), 1, 31)), as.matrix(substring(rownames(X.24h), 33)), X.24h)
colnames(D24h) <- c("Gene", "NAME", colnames(X.24h))
dim(D24h)
write.table(D24h, file="EBIC.24h.iPS.tsv", sep="\t", quote=F, row.names=F)

X.48h <- read.delim(Inpfile2, fileEncoding="latin1")
colnames(X.48h) <- read.delim(Inpfile2, fileEncoding="latin1", header=F, colClasses = "character")[1,1:ncol(X.48h)]
X.48h[is.na(X.48h)] <- 0

D48h <- cbind(as.matrix(substring(rownames(X.48h), 1, 31)), as.matrix(substring(rownames(X.48h), 33)), X.48h)
colnames(D48h) <- c("Gene", "NAME", colnames(X.48h))
dim(D48h)
write.table(D48h, file="EBIC.48h.iPS.tsv", sep="\t", quote=F, row.names=F)
