#!/usr/bin/perl

my $Time = $ARGV[0];

my $LFC_infile = "LFC_qRT-PCR/dCt.PCR.GENE.${Time}h.tsv";
my $Feature_infile = "GGMfiles/Feature_list.${Time}h.tsv";

my %ENSGhash = ();
open(FI, $Feature_infile) || die;
while(<FI>) {
  my (@cols) = split(/\t/, $_, -1);
  if(/^\d/) {
    my($ensg, $gene) = ($cols[1] =~ /^(EN.*):(.*)$/);

    $ENSGhash{$gene} = $cols[1];
  }
}
close FI;

my @headers = ();
open(FI, $LFC_infile) || die;
my %data = ();
my %solvent = ();

#Acetonylacetone_24h_DMSO        Acetonylacetone_24h_1/1 Acetonylacetone_24h_1/2 Acetonylacetone_24h_1/4 Acetonylacetone_24h_1/8 Acetonylacetone_24h_1/16
#ACTR3   4.6567  4.77820000000001        4.41585 4.6313  4.57635 4.8381
my %header_solvent_hash = ();
my $DMSO_flag = 0;
while(<FI>) {
  chomp;
  my (@cols) = split(/\t/, $_, -1);
  my $chem = $cols[0];
  $chem =~ s/_.*//;
  if(/DMSO/) {
    $DMSO_flag = 1;
    $header_solvent_hash{$chem} = 'DMSO';
    push(@headers, @cols[1..$#cols]);
    next;
  } elsif(/Water/) {
    $DMSO_flag = 0;
    $header_solvent_hash{$chem} = 'Water';
    push(@headers, @cols[1..$#cols]);
    next;
  }
  if(/\d/) {
    my $gene = $cols[0];
    push(@{$data{$gene}}, @cols[2..$#cols]);
    if($DMSO_flag == 1) {
      push(@{$solvent{$gene}->{'DMSO'}}, $cols[1]);
    } elsif($DMSO_flag == 0) {
      push(@{$solvent{$gene}->{'Water'}}, $cols[1]);
    }
  }
}
close FI;
@genes = sort keys %data;
print join("\t", @headers), "\n";
for(my $g = 0; $g <= $#genes; $g++) {
  my $gene = $genes[$g];

  my $ave_DMSO = 0;
  $ave_DMSO += $_ for @{$solvent{$gene}->{'DMSO'}};
  $ave_DMSO /= scalar @{$solvent{$gene}->{'DMSO'}};

  my $ave_Water = 0;
  $ave_Water += $_ for @{$solvent{$gene}->{'Water'}};
  $ave_Water /= scalar @{$solvent{$gene}->{'Water'}};

  my $ensggene = $ENSGhash{$gene};
  print $ensggene, "\t";
  my @vals = @{$data{$gene}};
  for(my $v = 0; $v <= $#vals; $v++) {
    print "\t" if($v);
    my $chem = $headers[$v];
    $chem =~ s/_.*//;
    if($header_solvent_hash{$chem} = 'DMSO') {
      print -($vals[$v] - $ave_DMSO);
    } elsif($header_solvent_hash{$chem} = 'Water') {
      print -($vals[$v] - $ave_Water);
    } else {
      die "### Wrong data !! ###\n";
    }
  }
  print "\n";
}
