#!/usr/bin/perl
my $Time = $ARGV[0];
my $PCR_file = "SourceFiles_qRTPCR/Summary_${Time}h.tsv";


my %vehcles = (
'Acetonylacetone' => 'DMSO',
'Acrylamide' => 'DMSO',
'Amiodarone' => 'DMSO',
'AmitriptylineHCl' => 'DMSO',
'Atorvastatin' => 'DMSO',
'Axitinib' => 'DMSO',
'Bucillamine' => 'DMSO',
'ButylatedHA' => 'DMSO',
'Chlorpheniramine' => 'DMSO',
'Chlorpromazine' => 'DMSO',
'Cisplatin' => 'Water',
'Cyclopamine' => 'DMSO',
'CyclosporinA' => 'DMSO',
'Digoxin' => 'DMSO',
'Doxorubicin' => 'DMSO',
'Gentamicin' => 'Water',
'Ibuprofen' => 'DMSO',
'Itraconazole' => 'DMSO',
'LithocholicAcid' => 'DMSO',
'MethapyrileneHCl' => 'Water',
'Sunitinib' => 'DMSO',
'Thioacetamide' => 'Water',
'ValproicAcid' => 'DMSO',
'VerapamilHCl' => 'DMSO'
);

print STDERR "Opening $PCR_file ...\n";
open(FI, $PCR_file) || die "## cannot open ##\n";
my @headers = ();
my %data = ();
while(<FI>) {
  s/\r//g;
  chomp;
  my (@cols) = split(/\t/, $_, -1);
  if(/^#/) {
    @headers = @cols;
    next;
  }
  $data{$cols[0]}->{$cols[1]} = {} unless(defined($data{$cols[0]}->{$cols[1]}));
  for(my $h = 2; $h <= $#headers; $h++) {
    my $header = $headers[$h];
    push(@{$data{$cols[0]}->{$cols[1]}->{$header}}, $cols[$h]);
  }
}
close FI;

my @chemnames = sort keys %data;
my @dosages = sort {my($aa) = ($a =~ /^1\/(\d+):/); my($bb) = ($b =~ /^1\/(\d+):/); $aa <=> $bb} @headers[2..$#headers];
for(my $c = 0; $c <= $#chemnames; $c++) {
  my $chem =  $chemnames[$c];
  my $vehcle = $vehcles{$chem};
  for(my $d = 0; $d <= $#dosages; $d++) {
    my $dose =  $dosages[$d];
    my($conc, $time) = ($dose =~ /(^.*):(.*)$/);
    if($dose =~ /^DMSO/ || $dose =~ /^Water/) {
      next if($conc ne $vehcle);
    }
    print "\t" if($conc ne $vehcle); 
    print $chem, "_", $time, "_", $conc;
  }
  print "\n";

  my @genenames = sort keys %{$data{$chem}};
  for(my $g = 0; $g <= $#genenames; $g++) {
    my $gene =  $genenames[$g];
    next if($gene eq 'GAPDH');
    print $gene;

    for(my $d = 0; $d <= $#dosages; $d++) {
      my $dose =  $dosages[$d];
      my($conc, $time) = ($dose =~ /(^.*):(.*)$/);
      if($dose =~ /^DMSO/ || $dose =~ /^Water/) {
        next if($conc ne $vehcle);
      }
      #print " ", $dose "=";
      my @vals = @{$data{$chem}->{$gene}->{$dose}};
      my @Gvals = @{$data{$chem}->{'GAPDH'}->{$dose}};
      my $dCt = ($vals[0]+$vals[1])/2 - ($Gvals[0]+$Gvals[1])/2;
      print "\t", $dCt;
    }
    print "\n";
  }
}
